/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19;
import lotus.domino.*; import djbuch.kapitel_06.*;
/**
 * @author Thomas Ekert
 * 
 */
public class AgentLogDemo implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = null; //"www.djbuch.de:63148"; 		//null fr lokale Session
	private static final String USER = null; //"Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	public static void main(String[] args) {
		AgentLogDemo tsAdvanced = new AgentLogDemo ();
		NotesThread nt = new NotesThread (tsAdvanced);
		nt.start();
	}
	
	public void run () {
		Session session = null;
		Log log=null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			log = session.createLog("DJBuch Notes Log");
			log.openNotesLog("Java/DJBuch","djbuch/djnoteslog.nsf");
			//log.openFileLog ("c:\\temp\\filelog.txt");
			log.logAction("Information im Notes Log");
			log.logError(123, "Mein Fehler mit Code 123");
			log.logAction("Noch mehr Information im Notes Log");
			log.logAction("Anzahl der Actions: " + log.getNumActions());
			log.logAction("Anzahl der Fehler: " + log.getNumErrors());
			log.logAction("Programm Name: " + log.getProgramName());
			log.close();
			GC.recycle (log);
			log = session.createLog("File Log");
			log.openFileLog("file.log");
			DJLog.info(""+log.isLogErrors());
			log.logAction("Information im Notes Log");
			log.logError(123, "Mein Fehler mit Code 123");
			log.logAction("Noch mehr Information im Notes Log");
			log.logAction("Anzahl der Actions: " + log.getNumActions());
			log.logAction("Anzahl der Fehler: " + log.getNumErrors());
			log.logAction("Programm Name: " + log.getProgramName());
			log.close();
		} catch (NotesException e) {
			System.out.println ("id = " + e.id);
			e.printStackTrace();
		} finally {
			GC.recycle (log);
			GC.recycle(session);
		}
	}
}
